/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.shelf.energy;

import com.marth7th.solidarytinker.register.solidarytinkerItem;
import com.marth7th.solidarytinker.register.solidarytinkerModifierMekEtsh;
import com.marth7th.solidarytinker.register.solidarytinkerToolstats;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.IToolStat;

public class FluxStorage
implements IEnergyStorage,
ToolCapabilityProvider.IToolCapabilityProvider {
    public static final ResourceLocation MAX_ENERGY = new ResourceLocation("solidarytinker", "max_energy");
    public static final ResourceLocation STORED_ENERGY = new ResourceLocation("solidarytinker", "stored_energy");
    public static final ResourceLocation ENERGY_OWNER = new ResourceLocation("solidarytinker", "energy_owner");
    public final Supplier<? extends IToolStackView> tool;
    public final LazyOptional<IEnergyStorage> capOptional;

    public FluxStorage(ItemStack stack, Supplier<? extends IToolStackView> toolStack) {
        this.tool = toolStack;
        this.capOptional = LazyOptional.of(() -> this);
    }

    public static int receiveEnergy(IToolStackView tool, int maxReceive, boolean simulate) {
        int energyStored = FluxStorage.getEnergyStored(tool);
        int tran = FluxStorage.checkTransport(tool);
        int energyReceived = Math.min(FluxStorage.getMaxEnergyStored(tool) - energyStored, Math.min(tran, maxReceive));
        int sss = Math.min(FluxStorage.getMaxEnergyStored(tool) - energyStored, energyReceived);
        if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored + sss);
        }
        return sss;
    }

    public static int checkTransport(IToolStackView tool) {
        int level = tool.getModifierLevel(solidarytinkerModifierMekEtsh.energytransport.getId());
        if (tool.getItem().equals(solidarytinkerItem.ElectricBatons.get())) {
            return 100000 + level * 30000;
        }
        return 2000 + level * 3000;
    }

    public static void removeEnergy(IToolStackView tool, int energyRemoved, boolean simulate, boolean drain) {
        int energyStored = FluxStorage.getEnergyStored(tool);
        if (energyStored < energyRemoved) {
            if (drain && !simulate) {
                ModDataNBT persistentData = tool.getPersistentData();
                persistentData.putInt(STORED_ENERGY, 0);
            }
        } else if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored - energyRemoved);
        }
    }

    public static int getEnergyStored(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        return persistentData.contains(STORED_ENERGY, 3) ? persistentData.getInt(STORED_ENERGY) : 0;
    }

    public static int getMaxEnergyStored(IToolStackView tool) {
        IModDataView volatileData = tool.getVolatileData();
        if (volatileData.contains(MAX_ENERGY, 3)) {
            int energy_store = tool.getStats().getInt((IToolStat)solidarytinkerToolstats.ENERGY_CAPACITY);
            return energy_store > 0 ? volatileData.getInt(MAX_ENERGY) + energy_store : volatileData.getInt(MAX_ENERGY);
        }
        return 0;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(IToolStackView tool, @NotNull Capability<T> cap) {
        return tool.getVolatileData().getInt(MAX_ENERGY) > 0 && cap == ForgeCapabilities.ENERGY ? ForgeCapabilities.ENERGY.orEmpty(cap, this.capOptional) : LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return FluxStorage.receiveEnergy(this.tool.get(), maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return FluxStorage.getEnergyStored(this.tool.get());
    }

    public int getMaxEnergyStored() {
        return FluxStorage.getMaxEnergyStored(this.tool.get());
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

